<span id="view_contact_page"></span>
<div class="row">
    <div class="col-md-12">
        <div class="col-sm-3">
            @include('contact.contact_basic_info')
        </div>
        <div class="col-sm-3 mt-56">
            @include('contact.contact_more_info')
        </div>

        @if($contact->type != 'customer')
            <div class="col-sm-3 mt-56">
                @include('contact.contact_tax_info')
            </div>
        @endif

        @if($contact->type == 'supplier' || $contact->type == 'both')
            <div class="clearfix"></div>
            <div class="col-sm-12">
                @if(($contact->total_purchase - $contact->purchase_paid) > 0)
                    <a href="{{ action([\App\Http\Controllers\TransactionPaymentController::class, 'getPayContactDue'], [$contact->id]) }}?type=purchase"
                       class="pay_purchase_due tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm pull-right">
                        <i class="fas fa-money-bill-alt" aria-hidden="true"></i>
                        @lang('contact.pay_due_amount')
                    </a>
                @endif
            </div>
        @endif

        @php
            $user = auth()->user();

            // Collect role names from Spatie (if present) and any custom fields, normalize to lowercase
            $role_names = collect([]);

            if ($user) {
                // Spatie roles (safe even if package not installed due to method_exists check)
                if (method_exists($user, 'roles')) {
                    try {
                        $role_names = $role_names->merge(
                            $user->roles->pluck('name')->map(fn($r) => strtolower(trim($r ?? '')))
                        );
                    } catch (\Throwable $e) {}
                }
                if (method_exists($user, 'getRoleNames')) {
                    try {
                        $role_names = $role_names->merge(
                            collect($user->getRoleNames())->map(fn($r) => strtolower(trim($r ?? '')))
                        );
                    } catch (\Throwable $e) {}
                }

                // Common custom fields
                foreach (['user_type', 'type', 'role', 'role_name'] as $f) {
                    if (isset($user->{$f}) && is_string($user->{$f})) {
                        $role_names->push(strtolower(trim($user->{$f})));
                    }
                }

                // If app stores a single role id/name elsewhere (array)
                if (isset($user->role_names) && is_array($user->role_names)) {
                    $role_names = $role_names->merge(
                        collect($user->role_names)->map(fn($r) => strtolower(trim($r ?? '')))
                    );
                }
            }

            // Unique, non-empty
            $role_names = $role_names->filter()->unique()->values();

            // Admins (and Accounting) should be allowed
            $is_admin_like = $role_names->contains(fn($r) => in_array($r, ['admin', 'administrator', 'owner', 'superadmin', 'accounting', 'accounts']));

            // Supplier users should be blocked (unless they’re admin-like)
            $is_supplier_like = $role_names->contains(fn($r) => in_array($r, ['supplier']));

            $should_disable_add_discount = $is_supplier_like && !$is_admin_like;
        @endphp

        <div class="col-sm-12">
            @if($should_disable_add_discount)
                {{-- Supplier (non-admin) sees a disabled, non-interactive button (no modal trigger) --}}
                <button type="button"
                        class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm pull-right tw-m-2 disabled"
                        disabled
                        aria-disabled="true"
                        style="pointer-events:none; opacity:.6; cursor:not-allowed"
                        title="@lang('messages.permission_denied')">
                    @lang('lang_v1.add_discount')
                </button>
            @else
                {{-- Admin / Accounting / other allowed roles --}}
                <button type="button"
                        class="tw-dw-btn tw-dw-btn-primary tw-text-white tw-dw-btn-sm pull-right tw-m-2"
                        data-toggle="modal"
                        data-target="#add_discount_modal">
                    @lang('lang_v1.add_discount')
                </button>
            @endif
        </div>
    </div>
</div>
